<?php

/* --------------------------------------------------------------
   HubListVaultThemeContentView.inc.php 2025-07-29
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2025 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class representing a gambio hub vault list content view
 */
class HubDeleteVaultThemeContentView extends ThemeContentView
{
    protected $vault_data = [];
    /**
     * HubListVaultThemeContentView constructor.
     * @throws Exception
     */
    public function __construct()
    {
        parent::__construct();

        $this->set_template_dir(DIR_FS_CATALOG . 'GXModules/Gambio/Hub/Shop/Html');
        $this->set_content_template('DeleteVault.html');
        $this->set_flat_assigns(true);
        $this->set_caching_enabled(false);
    }
    public function setVaultData(array $vaultData)
    {
        $this->vault_data = $vaultData;
    }

    public function prepare_data()
    {
        $format = "do=HubVault/Delete&vault_id=%s&type=%s&confirmation=true";
        $this->content_array['BUTTON_BACK_URL'] = xtc_href_link('shop.php', 'do=HubVault', 'SSL');
        $url = sprintf($format, $this->vault_data['token_id'], $this->vault_data['type']);
        $this->content_array['BUTTON_DELETE_URL'] =
            xtc_href_link(
                'shop.php',
                $url,
                'SSL'
            );
        if ($this->vault_data['type'] === 'paypal') {
            $view_data = $this->format_paypal_payment($this->vault_data, $this->vault_data['token_id']);
        } else {
            $view_data = $this->format_credit_card_payment($this->vault_data, $this->vault_data['token_id']);
        }
        $this->set_content_data('payment', $view_data);
    }
    
    protected function format_paypal_payment($payment, $tokenId)
    {
        return [
            'TYPE'              => 'paypal',
            'IMAGE'             => isset($payment['logo_url']) ? $payment['logo_url'] : 'image paypal',
            'ACCOUNT'           => isset($payment['email']) ? $payment['email'] : '',
            'NAME'              => isset($payment['name']) ? $payment['name'] : '',
            'BUTTON_DELETE_URL' => 'delete_payment.php?id=' . $tokenId,
            'PAYMENT_ID'        => $tokenId,
            'TOKEN_ID'          => $tokenId
        ];
    }

    protected function format_credit_card_payment($payment, $tokenId)
    {
        return [
            'TYPE'              => 'credit_card',
            'IMAGE'             => isset($payment['logo_url']) ? $payment['logo_url'] : 'image credit card',
            'CARDHOLDER_NAME'   => isset($payment['name']) ? $payment['name'] : '',
            'MASKED_NUMBER'     => isset($payment['last_digits_title']) ? $payment['last_digits_title'] : '',
            'EXPIRY_DATE'       => isset($payment['expiry']) ? $payment['expiry'] : '',
            'BRAND'             => isset($payment['brand']) ? $payment['brand'] : '',
            'TITLE'             => isset($payment['title']) ? $payment['title'] : '',
            'INFO_TEXT'         => isset($payment['info_text']) ? $payment['info_text'] : '',
            'IS_EXPIRED'        => isset($payment['is_expired']) ? $payment['is_expired'] : false,
            'BUTTON_DELETE_URL' => 'delete_payment.php?id=' . $tokenId,
            'PAYMENT_ID'        => $tokenId,
            'TOKEN_ID'          => $tokenId
        ];
    }
}
